/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.mobtimizations;

import com.corosus.coroutil.util.CU;
import com.corosus.mobtimizations.MobtimizationEntityFields;
import com.corosus.mobtimizations.config.ConfigFeatures;
import com.corosus.mobtimizations.config.ConfigFeaturesCustomization;
import com.corosus.modconfig.ConfigMod;
import com.corosus.modconfig.IConfigCategory;
import com.mojang.logging.LogUtils;
import java.io.File;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_14;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_7;
import org.slf4j.Logger;

public class Mobtimizations {
    public static final String MODID = "mobtimizations";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static boolean modActive = true;
    public static boolean testSpawningActive = false;
    private static int cancels = 0;

    public Mobtimizations() {
        new File("./config/mobtimizations").mkdirs();
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)new ConfigFeatures());
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)new ConfigFeaturesCustomization());
    }

    public static int getCancels() {
        return cancels;
    }

    public static void incCancel() {
        if (++cancels == Integer.MAX_VALUE) {
            cancels = 0;
        }
    }

    public static boolean rollPercentChance(float percent) {
        if (percent == 0.0f) {
            return false;
        }
        return CU.rand().nextFloat() <= percent / 100.0f;
    }

    public static boolean canAvoidHazards(class_1308 mob) {
        if (!modActive) {
            return true;
        }
        if (ConfigFeatures.optimizationMonsterHazardAvoidingPathfollowing) {
            return !(mob instanceof class_1588);
        }
        return true;
    }

    public static boolean canCrushEggs() {
        if (!modActive) {
            return true;
        }
        if (ConfigFeatures.optimizationZombieSearchAndDestroyTurtleEgg) {
            return Mobtimizations.rollPercentChance(ConfigFeaturesCustomization.zombieSearchAndDestroyTurtleEggPercentChance);
        }
        return true;
    }

    public static boolean canRecomputePath() {
        if (!modActive) {
            return true;
        }
        return !ConfigFeatures.optimizationMobRepathfinding;
    }

    public static boolean canVillageRaid() {
        if (!modActive) {
            return true;
        }
        if (ConfigFeatures.optimizationZombieVillageRaid) {
            return Mobtimizations.rollPercentChance(ConfigFeaturesCustomization.zombieVillageRaidPercentChance);
        }
        return true;
    }

    public static boolean canTarget(class_1308 mob) {
        if (!modActive) {
            return true;
        }
        if (ConfigFeatures.optimizationMobEnemyTargeting) {
            if (Mobtimizations.useReducedRates(mob)) {
                return Mobtimizations.rollPercentChance(ConfigFeaturesCustomization.mobEnemyTargetingReducedRatePercentChance);
            }
            return true;
        }
        return true;
    }

    public static boolean canWander(class_1308 mob) {
        if (!modActive) {
            return true;
        }
        if (ConfigFeatures.optimizationMobWandering) {
            if (!Mobtimizations.rollPercentChance(ConfigFeaturesCustomization.mobWanderingPercentChance)) {
                return false;
            }
            float multiplier = Mobtimizations.useReducedRates(mob) ? (float)ConfigFeaturesCustomization.mobWanderingReducedRateMultiplier : 1.0f;
            long lastWander = ((MobtimizationEntityFields)mob).getlastWanderTime();
            if ((float)lastWander + (float)ConfigFeaturesCustomization.mobWanderingDelay * multiplier > (float)mob.method_37908().method_8510()) {
                return false;
            }
            ((MobtimizationEntityFields)mob).setlastWanderTime(mob.method_37908().method_8510());
            return true;
        }
        return true;
    }

    public static boolean useReducedRates(class_1308 mob) {
        if (!ConfigFeatures.playerProximityReducedRate) {
            return false;
        }
        long lastPlayerScan = ((MobtimizationEntityFields)mob).getlastPlayerScanTime();
        if (lastPlayerScan + (long)ConfigFeaturesCustomization.playerProximityReducedRatePlayerScanRate > mob.method_37908().method_8510()) {
            return ((MobtimizationEntityFields)mob).isplayerInRange();
        }
        boolean playerInRangeBool = Mobtimizations.checkIfPlayerInRange(mob);
        ((MobtimizationEntityFields)mob).setplayerInRange(playerInRangeBool);
        ((MobtimizationEntityFields)mob).setlastPlayerScanTime(mob.method_37908().method_8510());
        return !playerInRangeBool;
    }

    private static boolean checkIfPlayerInRange(class_1308 mob) {
        for (class_1657 player : mob.method_37908().method_18456()) {
            if (!(player.method_5858((class_1297)mob) < (double)(ConfigFeaturesCustomization.playerProximityReducedRateRangeCutoff * ConfigFeaturesCustomization.playerProximityReducedRateRangeCutoff))) continue;
            return true;
        }
        return false;
    }

    public static class_7 getBlockPathTypeStatic(class_1922 p_77605_, class_2338.class_2339 p_77606_) {
        int i = p_77606_.method_10263();
        int j = p_77606_.method_10264();
        int k = p_77606_.method_10260();
        class_7 blockpathtypes = class_14.method_58((class_1922)p_77605_, (class_2338)p_77606_);
        if (blockpathtypes == class_7.field_7 && j >= p_77605_.method_31607() + 1) {
            class_7 blockpathtypes1 = class_14.method_58((class_1922)p_77605_, (class_2338)p_77606_.method_10103(i, j - 1, k));
            class_7 class_72 = blockpathtypes = blockpathtypes1 != class_7.field_12 && blockpathtypes1 != class_7.field_7 && blockpathtypes1 != class_7.field_18 && blockpathtypes1 != class_7.field_14 ? class_7.field_12 : class_7.field_7;
            if (blockpathtypes1 == class_7.field_3) {
                blockpathtypes = class_7.field_3;
            }
            if (blockpathtypes1 == class_7.field_17) {
                blockpathtypes = class_7.field_17;
            }
            if (blockpathtypes1 == class_7.field_21326) {
                blockpathtypes = class_7.field_21326;
            }
            if (blockpathtypes1 == class_7.field_33534) {
                blockpathtypes = class_7.field_36432;
            }
            if (blockpathtypes1 == class_7.field_43351) {
                blockpathtypes = class_7.field_43351;
            }
        }
        return blockpathtypes;
    }
}

